# Changelog

All notable changes to the `flutter_app_locker` package will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.0.5] - 2024-12-19

### Added
- Comprehensive dartdoc documentation for all public API elements
- Library-level documentation with usage examples and getting started guide
- Detailed documentation for `AppLocker`, `AppLockerConfig`, `LockScreen`, `Storage`, and `BiometricHelper` classes
- Usage examples and code snippets in documentation
- Export of `BiometricHelper` class for direct access

### Fixed
- Fixed type compatibility issue with `Icon(Icons.backspace)` in `LockScreen`
- Resolved static analysis warnings and errors
- Removed unused import of `biometric_helper.dart` from `app_locker.dart`
- Removed deprecated `author` field from `pubspec.yaml`
- Fixed downgrade compatibility issues

### Changed
- Improved code quality and maintainability
- Enhanced developer experience with better documentation
- Updated package structure for better organization

## [0.0.4] - 2024-12-19

### Added
- Initial release of flutter_app_locker package
- PIN-based authentication with customizable PIN length
- Biometric authentication support (fingerprint/Face ID)
- Auto-lock after inactivity timeout
- Secure storage of PIN using flutter_secure_storage
- Customizable lock screen UI
- Background app detection and auto-lock
- Manual lock/unlock methods
- Support for iOS, Android, and Web platforms

### Features
- `AppLocker` widget for wrapping your app
- `AppLockerConfig` for customizing lock behavior
- `LockScreen` widget for PIN and biometric authentication
- `Storage` class for secure PIN management
- `BiometricHelper` class for biometric authentication

---

## Version History

- **0.0.5**: Enhanced documentation and bug fixes
- **0.0.4**: Initial release with core functionality

## Migration Guide

### From 0.0.4 to 0.0.5

No breaking changes. This is a documentation and bug fix release.

## Contributing

When contributing to this package, please ensure that:

1. All public API elements have proper dartdoc documentation
2. Changes are documented in this CHANGELOG.md file
3. Code follows Dart and Flutter conventions
4. Tests are added for new functionality
5. Static analysis passes without warnings or errors

## Links

- [Package on pub.dev](https://pub.dev/packages/flutter_app_locker)
- [GitHub Repository](https://github.com/your-repo/flutter_app_locker)
- [Issue Tracker](https://github.com/your-repo/flutter_app_locker/issues) 