import 'package:flutter/material.dart';
import 'package:flutter_app_locker/flutter_app_locker.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return AppLocker(
      config: const AppLockerConfig(
        timeout: Duration(minutes: 1), 
        enableBiometric: true, 
      ),
      child: MaterialApp(
        title: 'App Locker Example',
        home: const HomePage(),
      ),
    );
  }
}

class HomePage extends StatelessWidget {
  const HomePage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('Trang chủ')), 
      body: Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            const Text('Ứng dụng đã được bảo vệ!'),
            const SizedBox(height: 24),
            ElevatedButton(
              onPressed: () => AppLocker.lock(context),
              child: const Text('Khóa ứng dụng thủ công'),
            ),
            ElevatedButton(
              onPressed: () => AppLocker.unlock(context),
              child: const Text('Mở khóa thủ công'),
            ),
          ],
        ),
      ),
    );
  }
} 