/// A Flutter library for locking your app with a PIN code or biometrics (fingerprint/Face ID).
/// 
/// This package provides a simple and secure way to add app locking functionality to your Flutter app,
/// similar to App Lock on Android/iOS. It supports both PIN-based authentication and biometric
/// authentication (fingerprint/Face ID).
/// 
/// ## Features
/// 
/// * PIN-based authentication with customizable PIN length
/// * Biometric authentication (fingerprint/Face ID) support
/// * Auto-lock after inactivity timeout
/// * Secure storage of PIN using flutter_secure_storage
/// * Customizable lock screen UI
/// * Background app detection and auto-lock
/// 
/// ## Usage
/// 
/// ```dart
/// import 'package:flutter_app_locker/flutter_app_locker.dart';
/// 
/// void main() {
///   runApp(
///     AppLocker(
///       config: AppLockerConfig(
///         timeout: Duration(minutes: 5),
///         enableBiometric: true,
///       ),
///       child: MyApp(),
///     ),
///   );
/// }
/// ```
/// 
/// ## Getting Started
/// 
/// 1. Add the package to your `pubspec.yaml`:
/// ```yaml
/// dependencies:
///   flutter_app_locker: ^0.0.4
/// ```
/// 
/// 2. Wrap your app with `AppLocker` widget
/// 3. Configure the lock behavior using `AppLockerConfig`
/// 4. The app will automatically lock after the specified timeout
/// 
/// For more information, see the [example](https://github.com/your-repo/flutter_app_locker/example).
library flutter_app_locker;

/// Main export for the flutter_app_locker package.
export 'src/app_locker.dart';
export 'src/lock_screen.dart';
export 'src/storage.dart';
export 'src/biometric_helper.dart'; 