# flutter_permission_guard

A permission control widget for Flutter, using the [permission_handler](https://pub.dev/packages/permission_handler) package.

- Wrap any widget, automatically check and request permissions (camera, microphone, location, ...)
- Support multiple permissions at once
- Customizable denied widget
- Callback when denied
- Beautiful, responsive, Material default UI

## Compatibility

> **This package requires Flutter >= 3.19.0 and Dart >= 3.3.0.**
>
> Please make sure your project uses a compatible Flutter and Dart version. This is required for compatibility with the latest permission_handler and modern Flutter features.


## Installation

Add to your pubspec.yaml:
```yaml
dependencies:
  flutter_permission_guard: ^0.0.2
```

## Basic usage

```dart
import 'package:flutter/material.dart';
import 'package:flutter_permission_guard/flutter_permission_guard.dart';
import 'package:permission_handler/permission_handler.dart';

class MyCameraView extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return PermissionGuard(
      permission: Permission.camera,
      child: CameraWidget(),
      // deniedWidget: CustomDeniedWidget(), // (Optional)
      // onDenied: () => print('Permission denied!'),
    );
  }
}
```

## Using multiple permissions

```dart
PermissionGuard.multi(
  permissions: [Permission.camera, Permission.microphone],
  child: MyWidget(),
)
```

## Custom denied UI

```dart
PermissionGuard(
  permission: Permission.location,
  child: MapWidget(),
  deniedWidget: Center(child: Text('You need to grant location permission!')),
)
```

## License
MIT

---

**Author:** Nguyen Thanh Bien (Nguyễn Thành Biên)  
**Email:** mortarcloud@gmail.com  
**Website:** [algonest.io.vn](https://algonest.io.vn)  
**Copyright:** Perpetual, unlimited use granted 