import 'package:flutter/material.dart';
import 'package:flutter_permission_guard/flutter_permission_guard.dart';
import 'package:permission_handler/permission_handler.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Permission Guard Example',
      theme: ThemeData(primarySwatch: Colors.blue),
      home: const HomePage(),
    );
  }
}

class HomePage extends StatelessWidget {
  const HomePage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('Demo PermissionGuard')),
      body: ListView(
        padding: const EdgeInsets.all(16),
        children: [
          // Ví dụ: kiểm tra quyền camera
          Text('Camera:', style: Theme.of(context).textTheme.titleMedium),
          PermissionGuard(
            permission: Permission.camera,
            child: Container(
              color: Colors.green[100],
              height: 80,
              alignment: Alignment.center,
              child: const Text('Đã có quyền camera!'),
            ),
            // deniedWidget: Center(child: Text('Bạn cần cấp quyền camera!')),
            // onDenied: () => print('Từ chối quyền camera'),
          ),
          const SizedBox(height: 32),
          // Ví dụ: kiểm tra nhiều quyền
          Text('Camera + Microphone:', style: Theme.of(context).textTheme.titleMedium),
          PermissionGuard.multi(
            permissions: [Permission.camera, Permission.microphone],
            child: Container(
              color: Colors.blue[100],
              height: 80,
              alignment: Alignment.center,
              child: const Text('Đã có cả camera & micro!'),
            ),
          ),
        ],
      ),
    );
  }
} 