# lan_discover

A Flutter package to scan the local LAN (Wi-Fi) network and discover devices connected to the same network. Designed for IoT developers to find devices like ESP32, Raspberry Pi, cameras, smart switches, or any custom embedded hardware within the same local network.

## Features
- Scan for devices in the local network (ping sweep / subnet scan)
- Show reachable IP addresses and optionally resolve hostnames
- Filter devices by port (e.g., 80, 443, 1883)
- Easy integration in Flutter apps
- Async support with cancellation
- Optional: mDNS (multicast DNS) discovery for devices broadcasting their identity

## Installation
Add to your `pubspec.yaml`:
```yaml
dependencies:
  lan_discover: ^0.0.1
```

## Quick Usage Example
```dart
import 'package:lan_discover/lan_discover.dart';

void main() async {
  final scanner = LanScanner();
  final devices = await scanner.scan();
  for (final device in devices) {
    print('Found: \\${device.ip} (host: \\${device.hostname})');
  }
}
```

## Example App
See the `example/` directory for a full Flutter demo app.

## Screenshots
<!-- Add screenshots here -->

## Roadmap / TODO
- [x] Basic ping sweep
- [x] Hostname resolution
- [x] Port filtering
- [ ] mDNS discovery
- [ ] UI improvements for example app
- [ ] Platform-specific optimizations

## License

This package is licensed under the MIT License. See the LICENSE file for details.

## Author

Nguyen Thanh Bien (Nguyễn Thành Biên)

- Email: mortarcloud@gmail.com
- Website: https://algonest.io.vn
- Copyright: Perpetual, unlimited use granted (Bản quyền sử dụng vĩnh viễn)

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## Issues

If you find any issues or have feature requests, please create an issue.
