# Contributing to Offline Messenger

Thank you for your interest in contributing to the Offline Messenger package! This document provides guidelines for contributing.

## Code Style

- Follow the Dart style guide
- Use meaningful variable and function names
- Add comments for complex logic
- Ensure all code is properly formatted with `dart format`

## Testing

- Write tests for new features
- Ensure all existing tests pass
- Maintain good test coverage
- Test on both Android and iOS platforms

## Pull Request Process

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests for new functionality
5. Ensure all tests pass
6. Update documentation if needed
7. Submit a pull request

## Reporting Issues

When reporting issues, please include:

- Flutter version
- Platform (Android/iOS)
- Device information
- Steps to reproduce
- Expected vs actual behavior
- Logs if available

## Development Setup

1. Clone the repository
2. Run `flutter pub get`
3. Run `flutter analyze` to check for issues
4. Run `flutter test` to run tests

## Code of Conduct

- Be respectful and inclusive
- Focus on the code and technical discussions
- Help others learn and grow

Thank you for contributing! 