# Security Policy

## Supported Versions

| Version | Supported          |
| ------- | ------------------ |
| 1.0.x   | :white_check_mark: |

## Reporting a Vulnerability

If you discover a security vulnerability within Offline Messenger, please send an email to mortarcloud@gmail.com. All security vulnerabilities will be promptly addressed.

## Security Considerations

- This package uses Bluetooth Low Energy (BLE) for communication
- Messages are transmitted in plain text over BLE
- No encryption is implemented in this version
- Users should be aware of the security implications of BLE communication
- Physical proximity is required for communication

## Best Practices

- Only connect to trusted devices
- Be aware of your surroundings when using this package
- Consider implementing additional encryption for sensitive data
- Regularly update to the latest version for security patches

## Disclosure Policy

- Security issues will be disclosed via GitHub Security Advisories
- Patches will be released as soon as possible
- Users will be notified of critical security updates 