# Offline Messenger Example

This is an example application demonstrating the usage of the `offline_messenger` package.

## Features

- Bluetooth device discovery
- Real-time messaging between devices
- Connection state monitoring
- Message history display
- User-friendly interface

## Getting Started

1. Ensure you have Flutter installed
2. Run `flutter pub get` to install dependencies
3. Run `flutter run` to start the application

## Usage

1. Launch the app
2. Grant Bluetooth permissions when prompted
3. Tap the search icon to start scanning for nearby devices
4. Tap "Connect" on a discovered device to establish a connection
5. Type messages in the input field and tap send to communicate

## Requirements

- Android: API level 21+ with Bluetooth LE support
- iOS: iOS 11.0+ with Bluetooth permissions
- Physical device (Bluetooth functionality not available in simulators)

## Permissions

The app requires the following permissions:
- Bluetooth access
- Location access (required for BLE scanning on Android)

## Troubleshooting

- Ensure Bluetooth is enabled on your device
- Grant all required permissions when prompted
- Make sure you're testing on a physical device, not a simulator 