# onboarding_tour

A Flutter package that helps developers easily create onboarding/app usage guides by highlighting specific widgets step by step (tour).

## Features
- Define multiple steps, each step attached to a `GlobalKey` to highlight the corresponding widget.
- Support spotlight (circle or rounded rectangle) to highlight widgets.
- Display tooltip/text explanation for each step, customizable position (top/bottom/left/right).
- Navigation buttons: **Next**, **Skip**, **Finish** tour.
- Customizable theme (dark/light), padding, animation.
- Callback when completing or skipping tour.
- No external packages (Flutter SDK only).
- Can restart tour anytime from code (`OnboardingTourController.start()`).
- Support for phones, tablets and web.

## Installation
Add to `pubspec.yaml`:
```yaml
dependencies:
  onboarding_tour: ^0.0.1
```

## Basic Usage
```dart
OnboardingTour(
  steps: [
    TourStep(
      key: _buttonKey,
      title: "Get Started",
      description: "Press this button to begin your journey",
    ),
    TourStep(
      key: _profileKey,
      title: "Profile",
      description: "View and edit user information",
    ),
  ],
  child: MyApp(),
)
```

## Complete Example
See file [`example/lib/main.dart`](example/lib/main.dart).

## Copyright
- Author: Nguyen Thanh Bien (Nguyễn Thành Biên)
- Email: mortarcloud@gmail.com
- Website: https://algonest.io.vn
- Copyright: Perpetual, unlimited use granted
