import 'package:flutter/material.dart';
import 'package:onboarding_tour/onboarding_tour.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final GlobalKey _buttonKey = GlobalKey();
  final GlobalKey _profileKey = GlobalKey();
  final OnboardingTourController _controller = OnboardingTourController();

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Onboarding Tour Example',
      home: OnboardingTour(
        controller: _controller,
        steps: [
          TourStep(
            key: _buttonKey,
            title: "Get Started",
            description: "Press this button to begin your journey",
            shape: SpotlightShape.circle,
            tooltipPosition: TooltipPosition.bottom,
          ),
          TourStep(
            key: _profileKey,
            title: "Profile",
            description: "View and edit user information",
            shape: SpotlightShape.roundedRect,
            tooltipPosition: TooltipPosition.right,
          ),
        ],
        child: HomeScreen(
          buttonKey: _buttonKey,
          profileKey: _profileKey,
          onStartTour: () => _controller.start(),
        ),
      ),
    );
  }
}

class HomeScreen extends StatelessWidget {
  final GlobalKey buttonKey;
  final GlobalKey profileKey;
  final VoidCallback onStartTour;

  const HomeScreen({
    super.key,
    required this.buttonKey,
    required this.profileKey,
    required this.onStartTour,
  });

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Onboarding Tour Demo'),
        actions: [
          IconButton(
            key: profileKey,
            icon: const Icon(Icons.person),
            onPressed: () {},
          ),
        ],
      ),
      body: Center(
        child: ElevatedButton(
          key: buttonKey,
          onPressed: onStartTour,
          child: const Text('Start Tour'),
        ),
      ),
    );
  }
} 