import 'package:flutter/widgets.dart';

enum SpotlightShape { circle, roundedRect }

enum TooltipPosition { top, bottom, left, right }

class TourStep {
  final GlobalKey key;
  final String title;
  final String description;
  final SpotlightShape shape;
  final TooltipPosition tooltipPosition;
  final EdgeInsets padding;

  TourStep({
    required this.key,
    required this.title,
    required this.description,
    this.shape = SpotlightShape.circle,
    this.tooltipPosition = TooltipPosition.bottom,
    this.padding = const EdgeInsets.all(8.0),
  });
} 