import 'package:flutter/material.dart';
import '../models/step_model.dart';

class Spotlight extends StatelessWidget {
  final Rect targetRect;
  final SpotlightShape shape;
  final double borderRadius;
  final Color color;
  final Duration animationDuration;

  const Spotlight({
    super.key,
    required this.targetRect,
    required this.shape,
    this.borderRadius = 16.0,
    this.color = const Color.fromRGBO(0, 0, 0, 0.7),
    this.animationDuration = const Duration(milliseconds: 300),
  });

  @override
  Widget build(BuildContext context) {
    return AnimatedOpacity(
      opacity: 1.0,
      duration: animationDuration,
      child: CustomPaint(
        size: MediaQuery.of(context).size,
        painter: _SpotlightPainter(
          targetRect: targetRect,
          shape: shape,
          borderRadius: borderRadius,
          color: color,
        ),
      ),
    );
  }
}

class _SpotlightPainter extends CustomPainter {
  final Rect targetRect;
  final SpotlightShape shape;
  final double borderRadius;
  final Color color;

  _SpotlightPainter({
    required this.targetRect,
    required this.shape,
    required this.borderRadius,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()
      ..color = color
      ..style = PaintingStyle.fill;
    canvas.drawRect(Offset.zero & size, paint);

    Path path = Path();
    if (shape == SpotlightShape.circle) {
      final center = targetRect.center;
      final radius = targetRect.longestSide / 2 + 12;
      path.addOval(Rect.fromCircle(center: center, radius: radius));
    } else {
      path.addRRect(RRect.fromRectAndRadius(
        targetRect.inflate(12),
        Radius.circular(borderRadius),
      ));
    }
    canvas.saveLayer(Offset.zero & size, Paint());
    canvas.drawPath(path, Paint()..blendMode = BlendMode.clear);
    canvas.restore();
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
} 