import 'package:flutter/material.dart';
import '../models/step_model.dart';

class TourTooltip extends StatelessWidget {
  final String title;
  final String description;
  final TooltipPosition position;
  final VoidCallback? onNext;
  final VoidCallback? onSkip;
  final VoidCallback? onFinish;
  final bool isLast;
  final bool isDark;

  const TourTooltip({
    super.key,
    required this.title,
    required this.description,
    required this.position,
    this.onNext,
    this.onSkip,
    this.onFinish,
    this.isLast = false,
    this.isDark = false,
  });

  @override
  Widget build(BuildContext context) {
    final theme = isDark ? ThemeData.dark() : ThemeData.light();
    return Material(
      color: Colors.transparent,
      child: Container(
        padding: const EdgeInsets.all(16),
        decoration: BoxDecoration(
          color: theme.cardColor,
          borderRadius: BorderRadius.circular(12),
          boxShadow: [
            BoxShadow(
              color: Colors.black26,
              blurRadius: 8,
              offset: Offset(0, 4),
            ),
          ],
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(title, style: theme.textTheme.titleMedium?.copyWith(fontWeight: FontWeight.bold)),
            const SizedBox(height: 8),
            Text(description, style: theme.textTheme.bodyMedium),
            const SizedBox(height: 16),
            Row(
              mainAxisAlignment: MainAxisAlignment.end,
              children: [
                TextButton(
                  onPressed: onSkip,
                  child: const Text('Skip'),
                ),
                if (!isLast)
                  ElevatedButton(
                    onPressed: onNext,
                    child: const Text('Next'),
                  ),
                if (isLast)
                  ElevatedButton(
                    onPressed: onFinish,
                    child: const Text('Finish'),
                  ),
              ],
            ),
          ],
        ),
      ),
    );
  }
} 