import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:onboarding_tour/onboarding_tour.dart';

void main() {
  group('OnboardingTour Tests', () {
    test('TourStep creation', () {
      final key = GlobalKey();
      final step = TourStep(
        key: key,
        title: 'Test Step',
        description: 'Test Description',
      );
      
      expect(step.key, equals(key));
      expect(step.title, equals('Test Step'));
      expect(step.description, equals('Test Description'));
      expect(step.shape, equals(SpotlightShape.circle));
      expect(step.tooltipPosition, equals(TooltipPosition.bottom));
    });

    test('OnboardingTourController creation', () {
      final controller = OnboardingTourController();
      expect(controller, isA<OnboardingTourController>());
    });
  });
}
