# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.1] - 2024-01-27

### Fixed
- Removed all icons from README and documentation for cleaner presentation
- Removed GitHub links and replaced with author website links
- Fixed deprecated API usage in screen information retrieval
- Improved null safety handling in device information methods
- Enhanced error handling for better fallback mechanisms
- Optimized analysis options for better code quality scores

### Improved
- Better documentation structure without emojis
- Cleaner code formatting and style consistency
- Enhanced platform support documentation
- Improved example code readability

## [1.0.0] - 2024-01-01

### Added
- Initial release of SmartDeviceInfo package
- Comprehensive device information retrieval
- Battery information with level, charging status, and health
- Screen information including dimensions, pixel ratio, and density
- CPU information with architecture and core count
- RAM information with total, available, and used memory
- Intelligent caching system for optimal performance
- Cross-platform support for Android, iOS, and web
- Error handling with robust fallback mechanisms
- Type-safe data models with full null safety support

### Technical Features
- Singleton pattern implementation for easy access
- Platform-specific implementations using device_info_plus and battery_plus
- JSON serialization/deserialization for all data models
- Formatted getters for user-friendly data display
- Comprehensive unit tests for all functionality
- Detailed documentation with examples
- MIT license with perpetual unlimited use granted

### Platform Support
- Android: Full device info, battery, screen, basic CPU/RAM
- iOS: Full device info, battery, screen, basic CPU/RAM
- Web: Full device info, limited battery, screen, basic CPU, no RAM

### Dependencies
- device_info_plus: ^9.1.2
- battery_plus: ^5.0.2
- universal_io: ^2.2.2
- package_info_plus: ^4.2.0
- flutter_lints: ^3.0.0

### Known Issues
- RAM information is limited on mobile platforms due to permission restrictions
- CPU frequency and detailed specs may not be available on all devices
- Battery information is not available on web platforms
- Some device-specific information may vary by manufacturer and OS version 