# Smart Device Info

A comprehensive Flutter package providing unified access to device information including hardware specs, OS details, and system resources with intelligent caching.

## Features

- **Device Information**: Get manufacturer, model, OS version, and device ID
- **Hardware Specs**: Access CPU architecture, cores, RAM usage, and screen details
- **Battery Status**: Monitor battery level, charging status, and health
- **Screen Metrics**: Retrieve screen size, pixel ratio, density, and orientation
- **Cross-Platform**: Works seamlessly on Android, iOS, and web
- **Intelligent Caching**: Results are memoized for optimal performance
- **Error Handling**: Graceful fallbacks for unavailable information
- **Lightweight**: Minimal overhead with efficient data structures

## Installation

Add this to your package's `pubspec.yaml` file:

```yaml
dependencies:
  smart_device_info: ^1.0.3
```

## Usage

```dart
import 'package:smart_device_info/smart_device_info.dart';

void main() async {
  // Get device information
  final deviceInfo = await SmartDeviceInfo.instance.getDeviceInfo();
  print('Device: ${deviceInfo.manufacturer} ${deviceInfo.model}');
  
  // Get battery status
  final batteryInfo = await SmartDeviceInfo.instance.getBatteryInfo();
  print('Battery: ${batteryInfo.levelPercentage}');
  
  // Get screen information
  final screenInfo = SmartDeviceInfo.instance.getScreenInfo();
  print('Screen: ${screenInfo.size}');
  
  // Get CPU information
  final cpuInfo = await SmartDeviceInfo.instance.getCpuInfo();
  print('CPU: ${cpuInfo.architecture} with ${cpuInfo.cores} cores');
  
  // Get RAM information
  final ramInfo = await SmartDeviceInfo.instance.getRamInfo();
  print('RAM: ${ramInfo.totalFormatted}');
}
```

## API Reference

### SmartDeviceInfo

The main singleton class providing access to all device information.

#### Methods

- `getDeviceInfo()`: Returns comprehensive device information
- `getBatteryInfo()`: Returns current battery status
- `getScreenInfo()`: Returns screen dimensions and properties
- `getCpuInfo()`: Returns CPU architecture and specifications
- `getRamInfo()`: Returns memory usage information
- `clearCache()`: Clears all cached data

### Data Models

- `DeviceInfo`: Device manufacturer, model, OS details
- `BatteryInfo`: Battery level, charging status, health
- `ScreenInfo`: Screen dimensions, pixel ratio, density
- `CpuInfo`: CPU architecture, cores, frequency
- `RamInfo`: Memory usage, total/available RAM

## Platform Support

| Platform | Device Info | Battery | Screen | CPU | RAM |
|----------|-------------|---------|--------|-----|-----|
| Android  | ✅ Full     | ✅ Full | ✅ Full| ✅ Basic| ❌ Limited |
| iOS      | ✅ Full     | ✅ Full | ✅ Full| ✅ Basic| ❌ Limited |
| Web      | ✅ Basic    | ❌ N/A  | ✅ Full| ❌ N/A| ❌ N/A |

## Development Services

Looking for professional Flutter development services? Visit [Algonest](https://algonest.io.vn) for:

- **[Flutter Development](https://algonest.io.vn)**: Custom mobile and web applications
- **[Game Development](https://algonest.io.vn)**: Cross-platform game development with Flutter
- **[Backend Development](https://algonest.io.vn)**: Robust server-side solutions and APIs
- **[UI/UX Design](https://algonest.io.vn)**: Beautiful and intuitive user interfaces
- **[Full-Stack Solutions](https://algonest.io.vn)**: Complete development from concept to deployment

Our team of experienced [Flutter developers](https://algonest.io.vn), [game developers](https://algonest.io.vn), and [backend developers](https://algonest.io.vn) specialize in creating high-performance applications with modern [UI/UX design](https://algonest.io.vn) principles.

## Issues

For issues and feature requests, please visit [Algonest](https://algonest.io.vn).

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Author

**Nguyen Thanh Bien**  
Email: mortarcloud@gmail.com  
Website: [https://algonest.io.vn](https://algonest.io.vn)

Perpetual unlimited use granted. 