# smart_form_validator_plus

A powerful, easy-to-use Flutter package for validating form fields with built-in and custom rules. International-ready, with English as default and full i18n/custom message support.

## Features
- Built-in validators: Email, Phone (international/E.164), Password strength, ID/Passport (customizable), Required
- Custom rule support with simple syntax
- Default error messages in English
- Easy to override/customize error messages (i18n ready)
- Easy integration with `TextFormField`/`TextField`
- Clean, extensible codebase


## Usage
```dart
import 'package:smart_form_validator_plus/smart_form_validator.dart';

TextFormField(
  validator: Validator.email,
)

TextFormField(
  validator: (value) => Validator.password(value, strict: true),
)

TextFormField(
  validator: (value) => Validator.phone(value), // International phone
)

TextFormField(
  validator: (value) => Validator.id(value, pattern: RegExp(r'^[A-Z0-9]{6,20} ')), // Custom ID/Passport
)

// Custom rule
TextFormField(
  validator: Validator.custom((value, {locale}) {
    if (value != 'flutter') {
      return 'Must be flutter';
    }
    return null;
  }),
)
```

## Internationalization (i18n)
- Default: English
- You can override all error messages globally:
```dart
ValidatorMessages.setCustomProvider((key, value, locale) {
  if (key == 'email') return 'Địa chỉ email không hợp lệ'; // Vietnamese example
  // ...other keys
  return 'Lỗi không xác định';
});
```
- Or use any i18n solution (intl, easy_localization, etc.)

## Example
See `/example` for a full demo app.

## Test
Run all tests:
```
flutter test
```

## License
Perpetual, unlimited use granted

**Author:** Nguyen Thanh Bien  
**Email:** mortarcloud@gmail.com  
**Website:** https://algonest.io.vn
