typedef ValidatorMessageProvider = String Function(String key, String? value, String? locale);

class ValidatorMessages {
  static ValidatorMessageProvider? _customProvider;

  static void setCustomProvider(ValidatorMessageProvider provider) {
    _customProvider = provider;
  }

  static String get(String key, {String? value, String? locale}) {
    if (_customProvider != null) {
      return _customProvider!(key, value, locale);
    }
    // Default English messages
    switch (key) {
      case 'email':
        return 'Invalid email address.';
      case 'phone':
        return 'Invalid phone number.';
      case 'password_weak':
        return 'Password is too weak.';
      case 'password_medium':
        return 'Password is medium. Consider making it stronger.';
      case 'password_strong':
        return 'Password is strong.';
      case 'id':
        return 'Invalid ID/Passport number.';
      case 'required':
        return 'This field is required.';
      default:
        return 'Invalid input.';
    }
  }
} 