import 'package:flutter_test/flutter_test.dart';
import 'package:smart_form_validator_plus/smart_form_validator.dart';

void main() {
  group('Email Validator', () {
    test('Valid email', () {
      expect(Validator.email('test@example.com'), null);
    });
    test('Invalid email', () {
      expect(Validator.email('test@'), isNotNull);
    });
  });

  group('Phone Validator', () {
    test('Valid VN phone', () {
      expect(Validator.phone('0912345678'), null);
    });
    test('Invalid VN phone', () {
      expect(Validator.phone('12345'), isNotNull);
    });
  });

  group('Password Validator', () {
    test('Weak password', () {
      expect(Validator.password('123'), isNotNull);
    });
    test('Medium password strict', () {
      expect(Validator.password('1234567', strict: true), isNotNull);
    });
    test('Strong password', () {
      expect(Validator.password('Abcdef12@#'), null);
    });
  });

  group('CMND/CCCD Validator', () {
    test('Valid 9 digits', () {
      expect(Validator.cmndCccd('123456789'), null);
    });
    test('Valid 12 digits', () {
      expect(Validator.cmndCccd('123456789012'), null);
    });
    test('Invalid', () {
      expect(Validator.cmndCccd('12345'), isNotNull);
    });
  });

  group('Required Validator', () {
    test('Empty', () {
      expect(Validator.required(''), isNotNull);
    });
    test('Not empty', () {
      expect(Validator.required('abc'), null);
    });
  });

  group('Multi-language', () {
    test('Vietnamese error', () {
      expect(Validator.email('abc', locale: ValidatorLocale.vi), 'Địa chỉ email không hợp lệ.');
    });
    test('English error', () {
      expect(Validator.email('abc', locale: ValidatorLocale.en), 'Invalid email address.');
    });
  });
}
