# ui_scaler

A simple Flutter package for responsive UI scaling: scale distances, paddings, margins, font sizes, etc. based on screen size. No external dependencies, only Flutter SDK.

## Features
- `ScaledBox` widget: like `SizedBox` but automatically scales `width` and `height` based on screen size.
- BuildContext extensions:
  - `context.scaled(value)`: scale a value by width or height.
  - `context.scaledFontSize(value)`: scale font size.
  - `context.scaledPadding(...)`: scale EdgeInsets for padding.
  - `context.scaledMargin(...)`: scale EdgeInsets for margin (alias for padding).
- Supports scaling by width or height (`ScaleMode.width` or `ScaleMode.height`).
- Custom scaling rules supported.
- Default scaling rules:
  - width < 600: scale = 1.0
  - width 600–1200: scale = 1.2
  - width > 1200: scale = 1.5

## Installation
Add to your `pubspec.yaml`:
```yaml
dependencies:
  ui_scaler: <latest_version>
```
Or for local development:
```yaml
dependencies:
  ui_scaler:
    path: ../ui_scaler
```

## Usage
Import the package:
```dart
import 'package:ui_scaler/ui_scaler.dart';
```

### ScaledBox
```dart
ScaledBox(width: 10, height: 20); // width and height are scaled automatically
```

### Scale any value
```dart
SizedBox(height: context.scaled(16)); // Scaled by width by default
SizedBox(width: context.scaled(24, mode: ScaleMode.height)); // Scale by height
```

### Scale font size
```dart
Text('Hello', style: TextStyle(fontSize: context.scaledFontSize(14)));
```

### Scale padding and margin
```dart
Padding(padding: context.scaledPadding(all: 12), child: ...);
Container(margin: context.scaledMargin(left: 8, right: 8), child: ...);
```

### Custom scaling rule
```dart
context.scaled(10, customScale: (width) => width < 800 ? 1.0 : 2.0);
```

### Full Example
See `example/lib/main.dart` for a complete demo.

## License
Perpetual, unlimited use granted.

## Author
Nguyen Thanh Bien (Nguyễn Thành Biên)  
Email: mortarcloud@gmail.com  
Website: https://algonest.io.vn
