import 'package:flutter/material.dart';
import 'package:ui_scaler/ui_scaler.dart';

void main() => runApp(const MyApp());

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'ui_scaler Example',
      home: Scaffold(
        appBar: AppBar(title: const Text('ui_scaler Example')),
        body: Center(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              ScaledBox(
                width: 100,
                height: 40,
                child: Container(
                  color: Colors.blue,
                  child: const Center(child: Text('ScaledBox')),
                ),
              ),
              const SizedBox(height: 24),
              Builder(
                builder: (context) => Text(
                  'Scaled font',
                  style: TextStyle(fontSize: context.scaledFontSize(18)),
                ),
              ),
              const SizedBox(height: 24),
              Builder(
                builder: (context) => Padding(
                  padding: context.scaledPadding(all: 16),
                  child: Container(
                    color: Colors.green,
                    child: const Text('Scaled Padding'),
                  ),
                ),
              ),
              const SizedBox(height: 24),
              Builder(
                builder: (context) => SizedBox(
                  height: context.scaled(32),
                  child: const Text('SizedBox height scaled'),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
} 